package de.brightbyte.yates;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import de.brightbyte.xml.XmlBuilder;
import de.brightbyte.xml.XmlUtil;

public class YatesHtml extends XmlBuilder {
	
	public static final StringMangler escaper = new StringMangler() {
		public String apply(String s) {
			return XmlUtil.escape(s);
		}
	};

	public static final StringMangler jsEscaper = new StringMangler() {
		public String apply(String s) {
			return s.replaceAll("['\"\\\\]", "\\\\$1");
		}
	};

	public static final StringMangler embeddedJsEscaper = new StringMangler() {
		public String apply(String s) {
			return escaper.apply(jsEscaper.apply(s));
		}
	};

	public static final StringMangler idEscaper = new StringMangler() {
		public String apply(String s) {
			try {
				return URLEncoder.encode(s, "UTF-8").replaceAll("%", ".");
			} catch (UnsupportedEncodingException e) {
				throw new Error("UTF-8 not supported");
			}
		}
	};

	public static final StringMangler urlEscaper = new StringMangler() {
		public String apply(String s) {
			try {
				return URLEncoder.encode(s, "UTF-8");
			} catch (UnsupportedEncodingException e) {
				throw new Error("UTF-8 not supported");
			}
		}
	};
	
}
