package de.brightbyte.yates;

import java.util.HashMap;
import java.util.Map;


public class RepeatMacro implements YatesMacro {
	public static final RepeatMacro instance = new RepeatMacro();
	
	public String render(YatesParameters parameters) throws YatesException {
		Number n = (Number)parameters.requireParameter("times", null);
		
		Object tpl = parameters.requireParameter("use", parameters.getParameter("_", null));
		
		String as = (String)parameters.getParameter("as", null);
		String between = (String)parameters.getParameter("between", null); //TODO: allow template here?
		
		YatesMacro template;
		if (tpl instanceof YatesMacro) template = (YatesMacro)tpl;
		else {
			template = parameters.getMacro(tpl.toString());
			if (template==null) throw new YatesException("no such template: "+tpl);
		}
		
		Map<String, Object> m = null;
		if (as!=null) m = new HashMap<String, Object>();
			
		boolean first = true;
		StringBuffer buffer = new StringBuffer(); //XXX: support direct output?
		
		for (int i=0; i<n.intValue(); i++) {
			if (first) first = false;
			else if (between!=null) buffer.append(between);
			
			Object item = i;
			if (m!=null) m.put("&"+as, item);

			YatesParameters p = new YatesParameters(parameters, m);
			p.setSubject(item);
			
			String s = template.render(p);
			buffer.append(s);
		}
		
		return buffer.toString();
	}

}
