package de.brightbyte.yates;

import javax.servlet.http.HttpServletRequest;

import de.brightbyte.abstraction.Abstractor;

public interface MacroRepository {
	public static final Abstractor<MacroRepository> abstractor = new Abstractor<MacroRepository>() {
	
		public void setProperty(MacroRepository obj, String name, Object template)
				throws IllegalArgumentException {
			
			try {
				obj.registerMacro(name, (YatesMacro)template);
			} catch (YatesException e) {
				throw new RuntimeException(e);
			}
		}
	
		public boolean isPropertyMutable(String name) {
			return true; //XXX: maybe...
		}
	
		public Class<MacroRepository> getTargetType() {
			return MacroRepository.class;
		}
	
		public Class getPropertyType(String property) {
			return YatesMacro.class;
		}
	
		public Object getProperty(MacroRepository obj, String name)
				throws IllegalArgumentException {
			try {
				return obj.getMacro(name);
			} catch (YatesException e) {
				throw new RuntimeException(e);
			}
		}

		public boolean hasProperty(MacroRepository obj, String name) {
			return getProperty(obj, name) != null;
		}
	
	};
	
	public YatesMacro getMacro(String name) throws YatesException;
	public void registerMacro(String name, YatesMacro template) throws YatesException;
}
