package de.brightbyte.yates;

import java.text.Format;

import de.brightbyte.data.Functor;

public class GenericValueRenderer implements YatesMacro {
	
	public static final GenericValueRenderer instance = new GenericValueRenderer();

	@SuppressWarnings("unchecked")
	public String render(YatesParameters parameters) throws YatesException {
		Object subject = parameters.getSubject();
		
		if (subject==null) {
			return parameters.getNullRenderer().render(parameters);
		}
		
		Object format = parameters.getParameter("format", null);
		String s;
		
		if (format instanceof String) {
			s = String.format(parameters.getLocale(), (String)format, subject);
		}
		else if (format instanceof Format) {
			s = ((Format)format).format(subject);
		}
		else if (format instanceof Functor) {
			s = ((Functor)format).apply(subject).toString();
		}
		else if (subject instanceof YatesMacro) {
			if (subject == this) throw new RuntimeException("GenericValueRenderer got itself as subject"); //XXX: sanity, see below
			s = ((YatesMacro)subject).render(parameters); //XXX: self as subject? is that good?...
		} 
		else {
			s = subject.toString(); 
		}
		
		return s;
	}

}
