package de.brightbyte.yates;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import de.brightbyte.db.ResultSetIterator;


public class ForEachMacro implements YatesMacro {
	public static final ForEachMacro instance = new ForEachMacro();
	
	public String render(YatesParameters parameters) throws YatesException {
		Object data = parameters.requireParameter("for", null);
		
		Object tpl = parameters.requireParameter("use", parameters.getParameter("_", null));
		
		String as = (String)parameters.getParameter("as", null);
		String between = (String)parameters.getParameter("between", null); //TODO: allow template here?
		
		YatesMacro template;
		if (tpl instanceof YatesMacro) template = (YatesMacro)tpl;
		else {
			template = parameters.getMacro(tpl.toString());
			if (template==null) throw new YatesException("no such template: "+tpl);
		}
		
		Map<String, Object> m = null;
		if (as!=null) m = new HashMap<String, Object>();
			
		boolean first = true;
		StringBuffer buffer = new StringBuffer(); //XXX: support direct output?
		Iterator it = getIterator(data);
		while (it.hasNext()) {
			if (first) first = false;
			else if (between!=null) buffer.append(between);
			
			Object item = it.next();
			if (m!=null) m.put("&"+as, item);

			YatesParameters p = new YatesParameters(parameters, m);
			p.setSubject(item);
			
			String s = template.render(p);
			buffer.append(s);
		}
		
		return buffer.toString();
	}

	protected Iterator getIterator(Object data) throws YatesException {
		if (data==null) throw new NullPointerException();
		
		//TODO: plugable converters!
		if (data instanceof Iterator) return (Iterator)data;
		else if (data instanceof Iterable) return ((Iterable)data).iterator();
		else if (data instanceof Map) return ((Map)data).entrySet().iterator();
		else if (data instanceof Object[]) return Arrays.asList((Object[])data).iterator();
		else if (data instanceof ResultSet) return new ResultSetIterator((ResultSet)data);
		//TODO: SQL ResultSets, BufferedReaders, etc
		
		throw new YatesException("not iterable: "+data.getClass());
	}

}
