package de.brightbyte.web.rip;

import java.util.HashMap;
import java.util.Map;

import de.brightbyte.net.UrlUtils;
import de.brightbyte.yates.YatesException;
import de.brightbyte.yates.YatesHtml;
import de.brightbyte.yates.YatesMacro;
import de.brightbyte.yates.YatesParameters;

public class YatesRipLinkMacro implements YatesMacro {

	public static final YatesRipLinkMacro instance = new YatesRipLinkMacro();

	public String render(YatesParameters parameters) throws YatesException {
		RipRequest handler = (RipRequest)parameters.resolve("handler");		
		
		String page = (String)parameters.getParameter("page", parameters.getParameter("href", handler.getFullPath()));		
		String tooltip = (String)parameters.getParameter("tooltip", parameters.getParameter("title", null));

		Object tpl = parameters.requireParameter("label", parameters.getParameter("_", null));

		YatesMacro template;
		if (tpl instanceof YatesMacro) template = (YatesMacro)tpl;
		else {
			template = parameters.getMacro(tpl.toString());
			if (template==null) throw new YatesException("no such template: "+tpl);
		}

		YatesParameters pp = new YatesParameters(parameters, null);
		String s = template.render(pp);
		
		Map<String, String> param = new HashMap<String, String>();

		String[] preserve = ((String)parameters.getParameter("preserve", "")).split("\\s*,\\s*");
		
		for (String p: preserve) {
			String v = handler.getParameter(p, null);
			if (v!=null) param.put(p, v);
		}
		
		Iterable<String> set = parameters.getParameterNames("param_"); //XXX: doc!
		for (String n: set) {
			Object v = parameters.getParameter(n, null);
			n = n.substring(6); //strip prefix
			
			if (v==null) continue;
			if (v.equals(Boolean.TRUE)) v = handler.getParameter(n, null);
			if (v.equals(Boolean.FALSE)) v = null;
			
			param.put(n, v==null ? null : v.toString());
		}
		
		if (!param.isEmpty()) {
			if ( page.indexOf('?')<0 ) page += "?";
			else page += "&";
			page += UrlUtils.joinParameters(param); 
		}

		//RipServlet servlet = (RipServlet)parameters.resolve("servlet");
		Map<String, Object> attr =new HashMap<String, Object>();
		attr.put("href", page);
		if (tooltip!=null) attr.put("title", tooltip);
		
		YatesHtml a = new YatesHtml();
		a.appendEscapedTag("a", s, attr);
		return a.toString();
	}

}
