package de.brightbyte.web.rip;

import java.util.HashMap;
import java.util.Map;

import de.brightbyte.net.UrlUtils;
import de.brightbyte.web.rip.DBQuery.Result;
import de.brightbyte.yates.ResultSetRenderer;
import de.brightbyte.yates.YatesException;
import de.brightbyte.yates.YatesHtml;
import de.brightbyte.yates.YatesParameters;

public class YatesDBQueryRenderer extends ResultSetRenderer {
	public static final YatesDBQueryRenderer instance = new YatesDBQueryRenderer();

	protected static final Map<String, Object> pagerAttributes;
	
	static {
		pagerAttributes = new HashMap<String, Object>();
		pagerAttributes.put("class", "pager");
	}
	

	@Override
	public String render(YatesParameters parameters) throws YatesException {
		RipRequest handler = (RipRequest)parameters.resolve("handler");		
		DBQuery.Result res = (DBQuery.Result)parameters.requireParameter("data", parameters.getSubject());

		YatesHtml s = new YatesHtml();
		
		Map<String, Object> divAttributes = getAttributes(parameters);
		Map<String, Object> tableAttributes = new HashMap<String, Object>(); 
		
		s.startTag("div", divAttributes);
		
		renderPager(res, s, handler);
		
		render(res.getResultSet(), tableAttributes, s);

		renderPager(res, s, handler);

		s.endTag("div");
		
		return s.toString();
	}

	protected void renderPager(Result res, YatesHtml s, RipRequest handler) {
		s.startTag("div", pagerAttributes);
		
		//TODO: i18n tooltips!
		renderLink(res, s, handler, "|<", "first", 0, res.getLimit()); 
		s.append("&nbsp;");
		renderLink(res, s, handler, "<<", "previous", Math.max(0, res.getOffset() - res.getLimit()), res.getLimit()); 
		s.append("&nbsp;");
		renderLink(res, s, handler, "20", "20", res.getOffset(), 20); 
		s.append("&nbsp;");
		renderLink(res, s, handler, "50", "50", res.getOffset(), 50); 
		s.append("&nbsp;");
		renderLink(res, s, handler, "100", "100", res.getOffset(), 100); 
		s.append("&nbsp;");
		renderLink(res, s, handler, "200", "200", res.getOffset(), 200); 
		s.append("&nbsp;");
		renderLink(res, s, handler, "500", "500", res.getOffset(), 500); 
		s.append("&nbsp;");
		renderLink(res, s, handler, ">>", "next", res.getOffset() + res.getLimit(), res.getLimit()); 
		
		s.endTag("div");
	}
	
	protected void renderLink(Result res, YatesHtml s, RipRequest handler, String label, String tooltip, int offset, int limit) {
		
		//XXX: massive overhead for parameter mangeling! can't we have this cheaper?
		
		String page = handler.getFullPath();
		Map<String, String[]> params = handler.getParameterMap();
		
		Map<String, String[]> p = new HashMap<String, String[]>();
		p.putAll(params);
		p.put(res.getLimitParameter(), new String[] { String.valueOf(limit) });
		p.put(res.getOffsetParameter(), new String[] { String.valueOf(offset) });
		
		Map<String, Object> attrs = new HashMap<String, Object>();
		attrs.put("title", tooltip);
		attrs.put("href", UrlUtils.appendParameters(page, p));		
		s.appendTag("a", label, attrs);
	}

}