package de.brightbyte.web.rip;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

public class TemplatedPage<T> extends AbstractPage {

	protected RipTemplateEngine<T> engine;
	protected T template;
	
	public TemplatedPage(RipTemplateEngine<T> engine, T template) throws IOException {
		this.engine = engine;
		this.template = template;
	}
	
	public void process(Map<String, Object> parameters, HttpServletResponse rp) throws IOException, RipException {
		setHeaders(parameters, rp);

		//TODO: optionally buffer first, then send (content length, etc)
		Writer out = rp.getWriter();
		engine.process(parameters, template, out, this);
		out.flush();
	}

}
