package de.brightbyte.web.rip;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Map;

public interface RipTemplateEngine<T> {
	//public T loadTemplate(String name, String path, String kind) throws IOException, RipException;
	public T loadTemplate(String name, URL url) throws IOException, RipException;
	public T loadTemplate(String name, Reader in) throws IOException, RipException;
	public T parseTemplate(String name, String template) throws RipException;
	
	//public TemplatedPage<T> newPage(String name, T template) throws RipException, IOException;

	public void process(Map<String, Object> parameters, T template, Writer out, TemplateContext context) throws IOException, RipException;
	
	public void putSharedValue(String name, Object value) throws RipException;
	public void putSetting(String name, Object value) throws RipException;
}
