package de.brightbyte.web.rip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

public class LiteralPage extends AbstractPage {

	private String text;
	private byte[] data;
	
	public LiteralPage(String text, String contentType, String contentEncoding) {
		this.text = text;
		setContentEncoding(contentEncoding);
		setContentType(contentType);
	}

	public LiteralPage(byte[] data, String contentType) {
		this.data = data;
		setContentType(contentType);
		setContentEncoding("ASCII");
	}

	public void process(Map<String, Object> parameters, HttpServletResponse rp) throws RipException, IOException {
		setHeaders(parameters, rp);
		
		if (text!=null) {
			Writer wr = rp.getWriter();
			wr.write(text);
			wr.flush();
		}
		else {
			rp.setContentLength(data.length);
			
			OutputStream out = rp.getOutputStream();
			out.write(data);
			out.flush();
		}
	}

	@Override
	public String getDefaultAction() {
		return null;
	}

}
