package de.brightbyte.web.rip;

import java.sql.ResultSet;
import java.sql.SQLException;

import de.brightbyte.db.DatabaseAccess;

public class DBQuery {
	
	public class Result {
		private ResultSet resultSet;
		private int offset;
		private int limit;
		private String[] order;
		
		public Result(ResultSet resultSet, int offset, int limit, String[] order) {
			super();
			this.resultSet = resultSet;
			this.offset = offset;
			this.limit = limit;
			this.order = order;
		}

		public int getLimit() {
			return limit;
		}

		public int getOffset() {
			return offset;
		}

		public String[] getOrder() {
			return order;
		}

		public ResultSet getResultSet() {
			return resultSet;
		}

		public String getLimitParameter() {
			return prefix+"lim";
		}

		public String getOffsetParameter() {
			return prefix+"ofs";
		}
		
		public String getOrderParameter() {
			return prefix+"by";
		}

		public void close() {
			try {
				resultSet.close();
			} catch (SQLException e) {
				//ignore. who cares?
			}
		}
		
	}
	
	protected RipServlet servlet;

	protected String query;
	protected String prefix;
	protected String name;
	protected boolean big = false;
	
	protected int defaultLimit = 50;
	protected String defaultOrder = null;

	protected RipRequest request;
	protected DatabaseAccess database;
	
	public DBQuery(RipServlet servlet, RipRequest rq, DatabaseAccess db, String name, String query) {
		this.servlet = servlet;
		this.prefix = prefix == null || prefix.equals("") ? "" : prefix+"-";
		this.name = name;
		this.query = query;
		this.request = rq;
		this.database = db;
	}
	
	public void setBigQueryMode(boolean big) {
		this.big = big;
	}
	
	public Result run() throws SQLException {
		int limit = getLimit();
		int offset = getOffset();
		String[] order = getOrder();

		String sql = getSQL(offset, limit, order);
		ResultSet rs = big ? database.executeBigQuery(name, sql) : database.executeQuery(name, sql);
		
		return new Result(rs, offset, limit, order);
	}

	protected String getSQL(int offset, int limit, String[] order) {
		String sql = query;
		
		if (order!=null && order.length>0) {
			sql += " ORDER BY ";
			boolean first = true;
			
			for (String o: order) {
				if (first==true) first = false;
				else sql += ", ";
				
				String dir = "ASC";
				if (o.startsWith("-")) {
					o = o.substring(1);
					dir = "DESC";
				}
				
				sql += database.quoteQualifiedName(o) + " " + dir;
			}
		}
		
		if (limit>0) {
			sql += " LIMIT ";
			if (offset>=0) sql += offset + ", ";
			sql += limit;
		}
		
		return sql;
	}

	protected String[] getOrder() {
		String order = request.getParameter(prefix + "by", defaultOrder);
		if (order==null) return null;
		else return order.split("[,|/\\s]+");
	}

	protected int getOffset() {
		return request.getIntParameter(prefix + "ofs", 0);
	}

	protected int getLimit() {
		return request.getIntParameter(prefix + "lim", defaultLimit);
	}

	public int getDefaultLimit() {
		return defaultLimit;
	}

	public void setDefaultLimit(int defaultLimit) {
		this.defaultLimit = defaultLimit;
	}

	public String getDefaultOrder() {
		return defaultOrder;
	}

	public void setDefaultOrder(String defaultOrder) {
		this.defaultOrder = defaultOrder;
	}

	public String getName() {
		return name;
	}

	public String getPrefix() {
		return prefix;
	}

	public String getQuery() {
		return query;
	}
	
	public String toString() {
		return query;
	}
}
