package de.brightbyte.yates;

import java.util.ArrayList;
import java.util.List;

public class MultiMacroRepository implements MacroRepository {
	
	protected MacroRepository primary = new SimpleMacroRepository();
	protected List<MacroRepository> repositories = new ArrayList<MacroRepository>();

	public MultiMacroRepository() {
		repositories.add(primary);
	}
	
	public YatesMacro getMacro(String name) throws YatesException {
		for(MacroRepository repos: repositories) {
			YatesMacro t = repos.getMacro(name);
			if (t!=null) return t;
		}
		
		return null;
	}

	public void registerMacro(String name, YatesMacro template) throws YatesException {
		primary.registerMacro(name, template);
	}

	public void addRepositories(MultiMacroRepository templates) {
		repositories.addAll(templates.repositories);
	}
	
	public void addRepository(MacroRepository repos) {
		repositories.add(repos);
	}

}
