package de.brightbyte.yates;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import de.brightbyte.abstraction.Abstractor;

public class HttpServletRequestAbstractor implements Abstractor<HttpServletRequest> {

	public static final HttpServletRequestAbstractor instance = new HttpServletRequestAbstractor(); 
	
	public Object getProperty(HttpServletRequest obj, String name) throws IllegalArgumentException {
		
		//NOTE: RipServlet decodes query parameters into a request attribute,
		//      so it can control the encoding used. So check for special 
		//		rip-decoded value first.
		Map<String, String[]> m = (Map<String, String[]>)obj.getAttribute("de.brightbyte.web.rip.RipServlet.queryParameter");
		if (m!=null) {
			String[] a = m.get(name);
			return a==null || a.length == 0 ? null : a[0];
		}
		else {
			return obj.getParameter(name);
		}
	}

	public Class getPropertyType(String property) {
		return String.class;
	}

	public Class<HttpServletRequest> getTargetType() {
		return HttpServletRequest.class;
	}

	public boolean isPropertyMutable(String name) {
		return false;
	}

	public void setProperty(HttpServletRequest obj, String name, Object v) throws IllegalArgumentException {
		throw new UnsupportedOperationException();
	}

	public boolean hasProperty(HttpServletRequest obj, String name) {
		return getProperty(obj, name) != null;
	}

}
