package de.brightbyte.yates;

public class BlockMacro implements YatesMacro {
	public static final BlockMacro instance = new BlockMacro();
	
	public String render(YatesParameters parameters) throws YatesException {
		Object tpl = parameters.requireParameter("use", parameters.getParameter("_", null));
		Object subject = parameters.getParameter("subject", parameters.getParameter("with", null));
		
		YatesMacro template;
		if (tpl instanceof YatesMacro) template = (YatesMacro)tpl;
		else {
			template = parameters.getMacro(tpl.toString());
			if (template==null) throw new YatesException("no such template: "+tpl);
		}
		
		YatesParameters p = new YatesParameters(parameters, null);
		if (subject!=null) p.setSubject(subject);
		
		return template.render(p);
	}

}