package de.brightbyte.web.rip;

import de.brightbyte.yates.YatesException;
import de.brightbyte.yates.YatesMacro;
import de.brightbyte.yates.YatesParameters;

public class YatesRipI18nMacro implements YatesMacro {

	public static final YatesRipI18nMacro instance = new YatesRipI18nMacro();

	public String render(YatesParameters parameters) throws YatesException {
		RipRequest handler = (RipRequest)parameters.resolve("handler");
		
		Object key = parameters.requireParameter("key", parameters.getParameter("_", null));
		
		if (key instanceof YatesMacro) {
			YatesMacro ktpl = (YatesMacro)key;
			YatesParameters pp = new YatesParameters(parameters, null);
			key = ktpl.render(pp);
		}
		else {
			key = key.toString();
		}

		
		String prefix = parameters.getParameter("prefix", "");
		String suffix = parameters.getParameter("suffix", parameters.getParameter("postfix", ""));
		
		key = prefix + key + suffix;
		
		String m = handler.getMessage((String)key);
		return m; //FIXME: html-escape here, for convenience?!
	}

}
