package de.brightbyte.web.rip;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

import de.brightbyte.io.IOUtil;
import de.brightbyte.yates.MacroRepository;
import de.brightbyte.yates.SimpleMacroRepository;
import de.brightbyte.yates.YatesContext;
import de.brightbyte.yates.YatesException;
import de.brightbyte.yates.YatesMacro;
import de.brightbyte.yates.YatesParameters;
import de.brightbyte.yates.YatesTemplate;

public class YatesEngine implements RipTemplateEngine<YatesTemplate> {

	protected String format;
	protected RipServlet servlet;
	protected YatesContext config = new YatesContext();
	
	protected MacroRepository repository = new SimpleMacroRepository(){
	
		public void registerMacro(String name, YatesMacro template) {
			throw new UnsupportedOperationException();
		}
	
		public YatesMacro getMacro(String name) throws YatesException {
			YatesMacro macro = super.getMacro(name);
			if (macro!=null) return macro;
			
			String ext = format;
			
			int idx = name.indexOf('.');
			if (idx>=0) {
				ext = name.substring(idx+1);
				name = name.substring(0, idx);
			}
			
			try {
				URL u = servlet.getTemplateURL(name, null, "yt", ext);
				if (u==null) return null;
				
				macro = loadTemplate(name, u);
				return macro;
			} catch (IOException e) {
				throw new YatesException(e);
			} catch (RipException e) {
				throw new YatesException(e);
			}
		}
	};
	
	public YatesEngine(RipServlet servlet, String format) {
		this.servlet = servlet;
		
		this.format = format;
		
		config.addMacroRepository(repository);
		config.setValueRenderer(DBQuery.Result.class, YatesDBQueryRenderer.instance);
		config.setMacro("link", YatesRipLinkMacro.instance);
		config.setMacro("i18n", YatesRipI18nMacro.instance);
		config.setMacro("DBQueryResult", YatesDBQueryRenderer.instance);
		
		//TODO: per-format escaper!
	}
	
	public YatesTemplate loadTemplate(String name, URL u) throws IOException, RipException {		
		URLConnection conn = u.openConnection();
		
		String enc;
		if (u.getProtocol().equals("file")) {
			//for local files, prefer configured encoding over java's guess
			enc = servlet.getEncoding();
			if (enc==null) enc = conn.getContentEncoding();
		}
		else {
			//for remote resources, trust the encoding the server reports
			enc = conn.getContentEncoding();
			if (enc==null) enc = servlet.getEncoding();
		}
		
		Reader in = new InputStreamReader(conn.getInputStream(), enc);
		YatesTemplate t = loadTemplate(name, in);
		in.close();
		
		return t;
	}

	public YatesTemplate loadTemplate(String name, Reader in) throws IOException, RipException {
		return parseTemplate(name, IOUtil.slurp(in));
	}

	public YatesTemplate parseTemplate(String name, String template) throws RipException {
		try {
			return new YatesTemplate(template);
		} catch (YatesException e) {
			throw new RipException(e);
		}
	}

	public void process(Map<String, Object> data, YatesTemplate template, Writer out, TemplateContext context) throws IOException, RipException {
		data.put("page", context.getPageOptionMap()); //per-page values
		YatesParameters param = new YatesParameters(config, null, data);  //per-engine config (settings, templates, etc)
		
		try {
			String s = template.render(param);
			out.write(s);
			out.flush();
		} catch (YatesException e) {
			throw new RipException(e);
		}
	}

	public void putSetting(String key, Object value) throws RipException {
		config.setSetting(key, value);
	}
	
	public void putSharedValue(String key, Object value) throws RipException {
		config.setSharedValue(key, value);
	}
	
	public void putTemplate(String key, Object template) throws RipException {
		config.setMacro(key, (YatesMacro)template);
	}

}
