package de.brightbyte.web.rip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import de.brightbyte.io.IOUtil;

public class StaticPage extends AbstractPage {

	private URL content;
	
	//TODO: for caching...
	//private byte[] data;
	//private Map<String, String> headers;
	
	public StaticPage(URL content) {
		super();

		this.content = content;
	}

	public void process(Map<String, Object> parameters, HttpServletResponse rp) throws RipException, IOException {
		//TODO: cache!
		
		URLConnection conn = content.openConnection();
		String p = content.getProtocol();
		
		String type;
		String enc;
		
		if (p.equals("http") || p.equals("https")) { //trust remote server
			type = conn.getContentType(); 
			enc = conn.getContentEncoding();
			
			if (type==null) type = getContentType();
			if (type==null) type = guessContentType(content);
			if (type==null) type = "unknown/unknown";
			if (enc==null) enc = getContentEncoding();
		}
		else { //probably local file or local jar
			type = guessContentType(content);
			enc = getContentEncoding();
			
			if (type==null) type = conn.getContentType(); 
			if (type==null) type = getContentType();
			if (type==null) type = "unknown/unknown";
		}
		
		setContentType(type); //XXX: currently redundant... see above
		setContentEncoding(enc);
		
		setHeaders(parameters, rp);
		
		InputStream in = conn.getInputStream();
		OutputStream out = rp.getOutputStream();
		IOUtil.pump(in, out);
		out.flush();
	}

	@Override
	public String getDefaultAction() {
		return null;
	}

}
