package de.brightbyte.web.rip;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MimeInfo {
	protected Map<String, List<String>> byType = new HashMap<String, List<String>>();
	protected Map<String, List<String>> byExt = new HashMap<String, List<String>>();
	
	public void load(URL url) throws IOException {
		InputStream in = url.openStream();
		load(in);
		in.close();
	}

	public void load(InputStream in) throws IOException {
		Properties p = new Properties();
		p.load(in);
		putAll(p);
	}

	public void putAll(Properties p) {
		Enumeration<String> en = (Enumeration<String>)p.propertyNames();
		while (en.hasMoreElements()) {
			String n = en.nextElement();
			String v = p.getProperty(n);
			String[] vv = v.trim().split("\\s+");
			
			put(n, vv);
		}
	}

	public void put(String mimeType, String[] extensions) {
		for (String ext: extensions) {
			put(mimeType, ext);
		}
	}

	public void put(String type, String ext) {
		type = normaizeType(type);
		ext = normaizeExtension(ext);

		List<String> bag = byType.get(type);
		if (bag==null) {
			bag = new ArrayList<String>();
			byType.put(type, bag);
		}
		bag.add(ext);
		
		bag = byExt.get(ext);
		if (bag==null) {
			bag = new ArrayList<String>();
			byExt.put(ext, bag);
		}
		bag.add(type);
	}
	
	public Iterable types() {
		return Collections.unmodifiableCollection(byType.keySet());
	}

	public Iterable extensions() {
		return Collections.unmodifiableCollection(byExt.keySet());
	}
	
	public String[] getExtensionsForType(String type) {
		type = normaizeType(type);
		List<String> a = byType.get(type);
		if (a==null) return new String[] {};
		else return (String[]) a.toArray(new String[a.size()]);
	}
	
	public String[] getTypesForExtension(String ext) {
		ext = normaizeExtension(ext);
		List<String> a = byExt.get(ext);
		if (a==null) return new String[] {};
		else return (String[]) a.toArray(new String[a.size()]);
	}
	
	public String guessExtensionForType(String type) {
		type = normaizeType(type);
		List<String> a = byType.get(type);
		if (a==null || a.isEmpty()) return null;
		else {
			String ext = a.get(0);
			if (ext==null) ext = type.replaceAll("^\\w+\\.(\\w+)", "$1");
			return ext;
		}
	}
	
	public String guessTypeForExtension(String ext) {
		ext = normaizeExtension(ext);
		List<String> a = byExt.get(ext);
		if (a==null || a.isEmpty()) return null;
		else return a.get(0);
	}
	
	protected static String normaizeType(String type) {
		return type.replaceAll("[;\\s].*$", "").trim().toLowerCase();
	}
	
	protected static String normaizeExtension(String type) {
		return type.replaceAll("^\\.", "").trim().toLowerCase();
	}

	public String guessTypeForName(String n) {
		n = n.replaceAll("^.*\\.([\\w\\d]+)$", "$1"); //TODO: precompiled, move to utils
		return guessTypeForExtension(n); //HACK
	}
}
