package de.brightbyte.web.rip;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;

public class FreeMarkerEngine implements RipTemplateEngine<Template> {

	protected Configuration config;
	protected RipServlet servlet;
	
	public FreeMarkerEngine(RipServlet servlet) {
		this.servlet = servlet;
		this.config = new Configuration();
	}
	
	public Template loadTemplate(String name, URL u) throws IOException, RipException {
		
		URLConnection conn = u.openConnection();
		String enc = conn.getContentEncoding();
		if (enc==null) enc = servlet.getEncoding();
		Reader in = new InputStreamReader(conn.getInputStream(), enc);
		Template t = loadTemplate(name, in);
		in.close();
		
		return t;
	}

	public Template loadTemplate(String name, Reader in) throws IOException, RipException {
		return new Template(name, in, config);
	}

	public Template parseTemplate(String name, String template) throws RipException{
		try {
			return loadTemplate(name, new StringReader(template));
		} catch (IOException e) {
			throw new Error("Unexpected IOException from StringReader");
		}
	}

	/*
	protected Object mangleModel(Object model) {
		return mangleMapModel((Map<String, Object>)model); //XXX: override if not a map.
	}
	
	protected Map<String, Object> mangleMapModel(Map<String, Object> model) {
		Map<String, Object> m = (Map<String, Object>)model;
		if (parameters!=null) {
			m = new HashMap<String, Object>();
			m.putAll((Map<String, Object>)model);
			m.put("page", Collections.unmodifiableMap(parameters));
		}
		
		return m;
	}
	 */
	
	public void process(Map<String, Object> parameters, Template template, Writer out, TemplateContext context) throws IOException, RipException {
		Map<String, Object> m = new HashMap<String, Object>();
		Map<String, Object> ctx = context.getPageOptionMap();
		if (ctx!=null || parameters!=null) {
			m = new HashMap<String, Object>(m);
			if (ctx!=null) m.put("page", Collections.unmodifiableMap(ctx));
			if (parameters!=null) m.putAll(parameters);
		}
		
		try {
			template.process(m, out);
		} catch (TemplateException e) {
			throw new RipException(e);
		}
	}

	public void putSetting(String key, Object value) throws RipException {
		try {
			config.setSetting(key, String.valueOf(value));
		} catch (TemplateException e) {
			throw new RipException(e);
		}
	}
	
	public void putSharedValue(String key, Object value) throws RipException {
		try {
			config.setSharedVariable(key, String.valueOf(value));
		} catch (TemplateException e) {
			throw new RipException(e);
		}
	}
	
	public void putTemplate(String key, Object template) throws RipException {
		try {
			config.setSharedVariable(key, template); //XXX: ?!
		} catch (TemplateException e) {
			throw new RipException(e);
		}
	}

}
