package de.brightbyte.web.rip;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import de.brightbyte.yates.LiteralMacro;

public abstract class AbstractPage implements RipPageHandler {

	protected String name;
	protected RipServlet servlet;
	protected Map<String, Object> context;
	
	public AbstractPage() {
		//noop
	}
	
	/*
	public AbstractPage(RipServlet servlet, String name) {
		this();
		attach(servlet, name);
	}
	*/
	
	public void attach(RipServlet servlet, String name) {
		if (name==null) throw new NullPointerException();
		if (servlet==null) throw new NullPointerException();
		
		this.name = name;
		this.servlet = servlet;
		
		String id;
		try {
			id = URLEncoder.encode(name, "UTF-8").replaceAll("[*._/%]", "-");
		} catch (UnsupportedEncodingException e) {
			throw new Error("UTF-8 not supported");
		}
		
		setPageOption("id", id);
		setPageOption("name", name);
		setPageOption("contentEncoding",  servlet.getEncoding());
		setPageOption("headTags",  LiteralMacro.blank );
	}

	public String getContentEncoding() {
		return (String)getPageOption("contentEncoding", servlet.getEncoding());
	}

	public void setContentEncoding(String contentEncoding) {
		setPageOption("contentEncoding", contentEncoding);
	}

	public String getContentType() {
		return (String)getPageOption("contentType", "text/html");
	}

	public void setContentType(String contentType) {
		setPageOption("contentType", contentType);
	}
	
	protected String guessContentType(URL u) {
		return servlet.guessContentType(u);
	}

	public String getName() {
		return name;
	}
	
	public String getDefaultAction() {
		return getName().replace('/', '_');
	}
	
	protected void setHeaders(Map<String, Object> parameters, HttpServletResponse rp) {
		rp.setContentType(getContentType()+"; charset="+getContentEncoding());
	}
	
	public void setPageOption(String name, Object value) {
		if (context==null) context = new HashMap<String, Object>();
		context.put(name, value);
	}
	
	public Object getPageOption(String name, Object def) {
		if (context==null) return def;
		Object v= context.get(name);
		if (v==null) v = def;
		return v;
	}

	public Map<String, Object> getPageOptionMap() {
		return context==null ? Collections.<String, Object>emptyMap() : Collections.unmodifiableMap(context);
	}
	
	//TODO: conveniance for error/failure
	//TODO: conveniance for redirect
    //TODO: conveniance for headers & cookies
}

	