package de.brightbyte.web.rip;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import de.brightbyte.yates.RipModel;

public class RipServlet extends HttpServlet {
	
	protected boolean usePathInfo = true;
	protected Map<String, RipPage> pages = new HashMap<String, RipPage>();

	protected RipPage getPage(HttpServletRequest rq) {
		String p = usePathInfo ? rq.getPathInfo() : rq.getServletPath();
		
		RipPage page = pages.get(p);
		return page;
	}
	
	@Override
	protected void doGet(HttpServletRequest rq, HttpServletResponse rp) throws ServletException, IOException {
		servePage(rq, rp);
	}

	@Override
	protected void doPost(HttpServletRequest rq, HttpServletResponse rp) throws ServletException, IOException {
		servePage(rq, rp);
	}

	@Override
	protected void servePage(HttpServletRequest rq, HttpServletResponse rp) throws ServletException, IOException {
		RipModel model = makeModel(rq);
		RipPage page = getPage(rq);
		String format = getRequestedFormat(rq);
		
		page.send(model, rp.getOutputStream(), format);
	}

	protected RipModel makeModel(HttpServletRequest rq) {
		RipModel m = new RipModel();
		m.apply(rq);
		return m;
	}

	@Override
	public void destroy() {
		super.destroy();
	}

	@Override
	public void init() throws ServletException {
		super.init();
	}

}
