package de.brightbyte.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.brightbyte.util.CollectionUtils;
import de.brightbyte.util.StringUtils;

public class XmlBuilder {
	
	protected StringBuilder buffer = new StringBuilder();
	
	public XmlBuilder() {
		//
	}
		
	public static String escape(String s) {
		return XmlUtil.escape(s);
	}
	
	public String toString() {
		return buffer.toString();
	}
	
	public void append(CharSequence html) {
		buffer.append(html);
	}

	public void appendEscaped(String s) {
		append(escape(s));
	}

	public void startTag(String t, Map<String, ? extends Object>... attrs) {
		openTag(t, attrs);
		closeTag(false);
	}
	
	public void appendEscapedTag(String t, String s, Map<String, ? extends Object>... attrs) {
		appendTag(t, s, attrs);
	}
	
	public void appendTag(String t, CharSequence html, Map<String, ? extends Object>... attrs) {
		openTag(t, attrs);
		if (html==null) {
			closeTag(true);
		}
		else {
			closeTag(false);
			append(html);
			endTag(t);
		}
	}
	
	public void openTag(String t, Map<String, ? extends Object>... attrs) {
		append("<");
		append(t);
		appendAttributes(attrs);
	}
	
	public void closeTag(boolean end) {
		if (end) append("/");
		append(">");
	}

	public void endTag(String t) {
		append("</");
		append(t);
		append(">");
	}

	public void appendAttributes(Map<String, ? extends Object>... attrs) {
		if (attrs==null || attrs.length==0 || attrs[0]==null) return;
		
		Map<String, ? extends Object> m = new HashMap<String, Object>();
		
		for (Map<String, ? extends Object> attr: attrs) {
			CollectionUtils.deepMerge((Map<String, Object>)m, (Map<String, Object>)attr);
		}
		
		attributesInternal(m, buffer);
	}
	
	private static void attributesInternal(Map<String, ? extends Object> attr, StringBuilder a) {
		if (attr==null || attr.isEmpty());
		
		for (Map.Entry<String, ? extends Object> e: attr.entrySet()) {
			String n = e.getKey();
			Object v = e.getValue();
			
			if (v==null) continue;
			if (v.equals(Boolean.FALSE)) continue; 
			
			String s = attributeValue(n, v);
			
			a.append(' ');
			a.append(n);
			a.append('=');
			a.append('"');
			a.append(XmlUtil.escape(s));
			a.append('"');
		}
	}

	public static String attributeValue(String n, Object v) {
		if (v.equals(Boolean.TRUE)) v = n; 
		
		String s;
		if (v instanceof Map) {
			if (n.equals("style")) {
				s = styles((Map<String, String>)v);
			}
			else {
				throw new IllegalArgumentException("value for attribute "+n+" must not be a map");
			}
		}
		else if (v instanceof List) {
			if (n.equals("id")) throw new IllegalArgumentException("id attribute can not be a list");
			s = StringUtils.join(" ", (List)v);
		}
		else if (v instanceof Object[]) {
			if (n.equals("id")) throw new IllegalArgumentException("id attribute can not be a list");
			s = StringUtils.join(" ", (Object[])v);
		}
		else if (v instanceof String || v.getClass().isPrimitive()) {
			s = v.toString();
		}
		else throw new IllegalArgumentException("bad type for value of attribute "+n+": "+v.getClass());
		
		return s;
	}

	public static String styles(Map<String, String> st) {
		if (st==null || st.isEmpty()) return "";
		
		StringBuilder s = new StringBuilder();
		
		for (Map.Entry<String, String> e: st.entrySet()) {
			String n = e.getKey();
			String v = e.getValue();
			
			if (v==null) continue;
			
			s.append(' ');
			s.append(n);
			s.append(':');
			s.append(v);
			s.append(';');
		}
		
		return s.toString();
	}
}
