package de.brightbyte.xml;

import junit.framework.TestCase;

public class HtmlEntitiesTest extends TestCase {

	public void testDecodeEntities() {
		assertEquals("(empty)", "", HtmlEntities.decodeEntities(""));
		assertEquals("-&lt;&auml;&gt;-", "-<\u00e4>-", HtmlEntities.decodeEntities("-&lt;&auml;&gt;-"));
		assertEquals("&#x24;&#x24;&#x24;", "$$$", HtmlEntities.decodeEntities("&#x24;&#x24;&#x24;"));
		assertEquals("&#x5c;&#x5c;&#x5c;", "\\\\\\", HtmlEntities.decodeEntities("&#x5c;&#x5c;&#x5c;"));
		assertEquals("-&#x5c;&#x24;-", "-\\$-", HtmlEntities.decodeEntities("-&#x5c;&#x24;-"));
	}

	public void testResolveEntity() {
		assertEquals("&amp;", "&", HtmlEntities.resolveEntity("amp"));
		assertEquals("&lt;", "<", HtmlEntities.resolveEntity("lt"));
		assertEquals("&gt;", ">", HtmlEntities.resolveEntity("gt"));
		assertEquals("&quot;", "\"", HtmlEntities.resolveEntity("quot"));
		assertEquals("&apos;", "'", HtmlEntities.resolveEntity("apos"));

		assertEquals("&auml;", "\u00e4", HtmlEntities.resolveEntity("auml"));
		assertEquals("&nbsp;", "\u00a0", HtmlEntities.resolveEntity("nbsp"));
		assertEquals("&euro;", "\u20ac", HtmlEntities.resolveEntity("euro"));
		
		assertEquals("&#32;", " ", HtmlEntities.resolveEntity("#32"));		
		assertEquals("&#0032;", " ", HtmlEntities.resolveEntity("#0032"));		
		assertEquals("&#x20;", " ", HtmlEntities.resolveEntity("#x20"));		
		assertEquals("&#x0020;", " ", HtmlEntities.resolveEntity("#x0020"));
		
		//TODO: how about supplement planes? i.e. stuff that doesn't fit into utf16?  
	}

}
