package de.brightbyte.util;

public class Throttle {
	protected long chunkStart = 0;
	protected int chunkCounter = 0;
	
	protected int chunkDuration;
	protected int chunkLimit;
	
	public Throttle(int chunkDuration, int chunkLimit) {
		super();
		this.chunkDuration = chunkDuration;
		this.chunkLimit = chunkLimit;
	}
	
	public synchronized int request(int count) throws InterruptedException {
		long t = chunkDuration - (System.currentTimeMillis() - chunkStart);
		while (t>0 && chunkCounter>=chunkLimit) {
			if (t<=0) break;
			wait(t);
			t = chunkDuration - (System.currentTimeMillis() - chunkStart);
		}
		
		if (t<=0) {
			chunkStart = System.currentTimeMillis();
			chunkCounter = 0;
		}
		
		int available = chunkLimit - chunkCounter;
		int c;
		
		if (available<count) c = available;
		else c = count;
		
		chunkCounter += c;
		return c;
	}
	
	public static void main(String[] args) throws InterruptedException {
		final Throttle th = new Throttle(1000, 100);

		Runnable r = new Runnable() {
			public void run() {
				for (int i=0; i<10; i++) {
					try {
						int x = th.request(44);
						System.out.println(Thread.currentThread().getName()+":"+x);
						Thread.yield();
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
			}
		};

		Thread t1 = new Thread(r, "1"); t1.start();
		Thread t2 = new Thread(r, "2"); t2.start();
		Thread t3 = new Thread(r, "3"); t3.start();
	}
}
