package de.brightbyte.util;

import junit.framework.TestCase;

public class StringUtilsTest extends TestCase {

	public void testIndexOfCharCharSequence() {
		assertEquals(-1, StringUtils.indexOf('x', ""));
		assertEquals(-1, StringUtils.indexOf('x', "abc"));
		assertEquals(0, StringUtils.indexOf('x', "xab"));
		assertEquals(1, StringUtils.indexOf('x', "axb"));
		assertEquals(2, StringUtils.indexOf('x', "abx"));
	}

	public void testStrip() {
		StringBuilder s;
		
		s = new StringBuilder("");
		StringUtils.strip(s);
		assertEquals("", s.toString());
		
		s = new StringBuilder("\n");
		StringUtils.strip(s);
		assertEquals("", s.toString());
		
		s = new StringBuilder("x");
		StringUtils.strip(s);
		assertEquals("x", s.toString());
		
		s = new StringBuilder("xyz");
		StringUtils.strip(s);
		assertEquals("xyz", s.toString());
		
		s = new StringBuilder("\nxyz");
		StringUtils.strip(s);
		assertEquals("xyz", s.toString());
		
		s = new StringBuilder("\nxyz\n");
		StringUtils.strip(s);
		assertEquals("xyz", s.toString());
		
		s = new StringBuilder("xyz\n");
		StringUtils.strip(s);
		assertEquals("xyz", s.toString());
		
		s = new StringBuilder("\n\t xyz \t\n");
		StringUtils.strip(s);
		assertEquals("xyz", s.toString());
		
		s = new StringBuilder(" a b ");
		StringUtils.strip(s);
		assertEquals("a b", s.toString());
	}

	public void testTrim() {
		assertEquals("", StringUtils.trim("").toString());
		assertEquals("", StringUtils.trim("\n").toString());
		assertEquals("x", StringUtils.trim("x").toString());
		assertEquals("xyz", StringUtils.trim("xyz").toString());
		assertEquals("xyz", StringUtils.trim("\nxyz").toString());
		assertEquals("xyz", StringUtils.trim("\nxyz\n").toString());
		assertEquals("xyz", StringUtils.trim("xyz\n").toString());
		assertEquals("xyz", StringUtils.trim("\n\t xyz \t\n").toString());
		assertEquals("x y z", StringUtils.trim(" x y z ").toString());
	}

	public void testSubst() {
		StringBuilder s;
		
		s = new StringBuilder("");
		StringUtils.subst(s, 'x', 'X');
		assertEquals("", s.toString());
		
		s = new StringBuilder("abc");
		StringUtils.subst(s, 'x', 'X');
		assertEquals("abc", s.toString());
		
		s = new StringBuilder("axbxc");
		StringUtils.subst(s, 'x', 'X');
		assertEquals("aXbXc", s.toString());
		
		s = new StringBuilder("x");
		StringUtils.subst(s, 'x', 'X');
		assertEquals("X", s.toString());
	}

	public void testReplaceCharSequenceCharChar() {
		assertEquals("", StringUtils.replace("", 'x', 'X').toString());
		assertEquals("abc", StringUtils.replace("abc", 'x', 'X').toString());
		assertEquals("aXbXc", StringUtils.replace("axbxc", 'x', 'X').toString());
		assertEquals("X", StringUtils.replace("x", 'x', 'X').toString());
	}
	
	public void testEqualsStringString() {
		assertEquals(true, StringUtils.equals("x", "x"));
		assertEquals(false, StringUtils.equals("x", "y"));

		assertEquals(true, StringUtils.equals("x", new StringBuilder("x")));
		assertEquals(false, StringUtils.equals("x", new StringBuilder("y")));

		assertEquals(true, StringUtils.equals(new StringBuilder("x"), new StringBuilder("x")));
		assertEquals(false, StringUtils.equals(new StringBuilder("x"), new StringBuilder("y")));
	}


}
