package de.brightbyte.util;

import static de.brightbyte.util.PowerMath.*;

import java.math.BigDecimal;
import java.math.MathContext;


public class StatMath {
	
	/**
	 * Fischer's exact test.
	 * 
	 * a value &lt 0.05 indicates significant dependence (for 95% confidence)
	 */
	public static double feTest(long a, long b, long c, long d) {
		return ( faculty(a+c) * faculty(b+d) * faculty(a+b) * faculty(c+d) ) 
			/ ( faculty(a+b+c+d) * faculty(a) * faculty(b) * faculty(c) * faculty(d)  );
	}

	/**
	 * Fischer's exact test.
	 * 
	 * a value &lt 0.05 indicates significant dependence (for 95% confidence)
	 */
	public static BigDecimal feTest(BigDecimal a, BigDecimal b, BigDecimal c, BigDecimal d, 
            MathContext mx) {
		BigDecimal v;
		v = faculty(a.add(c));
		v = v.multiply(faculty(b.add(d)));
		v = v.multiply(faculty(a.add(b)));
		v = v.multiply(faculty(c.add(d)));
		
		BigDecimal f;
		f = faculty(a.add(b).add(c).add(d));
		f = f.multiply(faculty(a));
		f = f.multiply(faculty(b));
		f = f.multiply(faculty(c));
		f = f.multiply(faculty(d));
		
		return v.divide(f, mx);
	}
}

	