package de.brightbyte.util;

import java.math.BigDecimal;
import java.math.MathContext;

public class PowerMath {
	public static long raise(long d, long e) {
		if (e==0) return 1;
		if (e==1) return d;
		if (e==-1) return 1 / d;
		
		if (d==0) return 0;
		if (d==1) return 1;

		boolean neg = e < 0;
		if (neg) e = -e;
		
		long f = d;
		for (long i = 2; i<=e; i++) {
			f *= d;
		}
		
		if (neg) f = 1/f;
		return f;
	}

	public static BigDecimal raise(BigDecimal d, long e, MathContext mx) {
		if (e==0) return BigDecimal.ONE;
		if (e==1) return d;
		if (e==-1) return BigDecimal.ONE.divide(d);

		if (d.equals(BigDecimal.ZERO)) return BigDecimal.ZERO;
		if (d.equals(BigDecimal.ONE)) return BigDecimal.ONE;

		boolean neg = e < 0;
		if (neg) e = -e;
		
		BigDecimal f = d;
		for (long i = 2; i<=e; i++) {
			f = f.multiply(d);
		}
		
		if (neg) f = BigDecimal.ONE.divide(f, mx);
		return f;
	}

	public static BigDecimal raise(BigDecimal d, BigDecimal e, MathContext mx) {
		if (e.equals(BigDecimal.ZERO)) return BigDecimal.ONE;
		if (e.equals(BigDecimal.ONE)) return d;
		if (e.equals(BigDecimal.ONE.negate())) return BigDecimal.ONE.divide(d, mx);

		if (d.equals(BigDecimal.ZERO)) return BigDecimal.ZERO;
		if (d.equals(BigDecimal.ONE)) return BigDecimal.ONE;

		boolean neg = e.compareTo(BigDecimal.ZERO) < 0;
		if (neg) e = e.negate();
		
		BigDecimal f = d;
		for (BigDecimal i = new BigDecimal(2); i.compareTo(e)<=0; i.add(BigDecimal.ONE)) {
			f = f.multiply(d);
		}
		
		if (neg) f = BigDecimal.ONE.divide(f, mx);
		return f;
	}

	public static long faculty(long d) {
		if (d<0) throw new IllegalArgumentException("must not be negative");
		if (d==0) return 1;
		if (d==1) return 1;
		if (d==2) return 2;

		long f = 1;
		for (long i = 2; i<=d; i++) {
			f *= i;
		}
		
		return f;
	}

	public static BigDecimal faculty(BigDecimal d) {
		if (d.compareTo(BigDecimal.ZERO)<0) throw new IllegalArgumentException("must not be negative");
		if (d.equals(BigDecimal.ZERO)) return BigDecimal.ONE;
		if (d.equals(BigDecimal.ONE)) return BigDecimal.ONE;

		BigDecimal f = new BigDecimal(1);
		for (BigDecimal i = new BigDecimal(2); i.compareTo(d)<=0; i = i.add(BigDecimal.ONE)) {
			f = f.multiply(i);
		}
		
		return f;
	}
	
	public static long binomial(long n, long k) {
		if (n<0) throw new IllegalArgumentException("n must not be negative");
		if (k<0) throw new IllegalArgumentException("k must not be negative");

		if (k==0) return 1;
		if (n==k) return 1;
		if (n<k) throw new IllegalArgumentException("n must not be smaller than k");
		
		if (2*k > n) return binomial(n, n-k);
		else {
			long bc = n;
			for (int i = 2; i<=k; i++) {
				bc = bc * (n + 1 - i) / i;
			}
			return bc;
		}		
	}
	
	protected static final BigDecimal TWO = new BigDecimal(2);

	public static BigDecimal binomial(BigDecimal n, BigDecimal k, MathContext mx) {
		if (n.compareTo(BigDecimal.ZERO)<0) throw new IllegalArgumentException("n must not be negative");
		if (k.compareTo(BigDecimal.ZERO)<0) throw new IllegalArgumentException("k must not be negative");

		if (k.compareTo(BigDecimal.ZERO)==0) return BigDecimal.ONE;
		if (n.equals(k)) return BigDecimal.ONE;
		if (n.compareTo(k)<0) throw new IllegalArgumentException("n must not be smaller than k");

		if (k.multiply(TWO).compareTo(n) > 0) return binomial(n, n.subtract(k), mx);
		else {
			BigDecimal bc = n;
			for (BigDecimal i = TWO; i.compareTo(k)<=0; i = i.add(BigDecimal.ONE)) {
				bc = bc.multiply(n.add(BigDecimal.ONE).subtract(i)).divide(i, mx);
			}
			return bc;
		}		
	}
}
