package de.brightbyte.util;

/**
 * Indicates that something went wrong when storing data to or 
 * retrieving data from a persistance layer. This can bee seen as 
 * a generalization of exceptions arising when accessing files,
 * databases, etc.
 */
public class PersistenceException extends Exception {

	public PersistenceException() {
		super();
	}

	public PersistenceException(String message) {
		super(message);
	}

	public PersistenceException(Throwable cause) {
		super(cause);
	}

	public PersistenceException(String message, Throwable cause) {
		super(message, cause);
	}

}
