package de.brightbyte.util;

import java.util.Collection;
import java.util.Map;

public class CollectionUtils {

	public static <K,V> Map<K, V> deepMerge(Map<K, V> a, Map<K, V> b) {
		for (Map.Entry<K, V> e: b.entrySet()) {
			K k = e.getKey();
			V vb = e.getValue();
			
			if (vb==null) continue;
			
			V va = a.get(k);
			
			if (va==null) {
				a.put(k, vb);
			}
			else if (va instanceof Map) {
				if (vb instanceof Map) {
					deepMerge((Map)va, (Map)vb);
				}
				else {
					throw new IllegalArgumentException("can't merge instance of "+vb.getClass()+" into map (key was: "+k+")");
				}
			}
			else if (va instanceof Collection) {
				if (vb instanceof Collection) {
					((Collection)va).addAll((Collection)vb);
				}
				else {
					((Collection)va).add(vb);
				}
			}
			else {
				if (vb instanceof Map) {
					throw new IllegalArgumentException("can't merge instance of "+va.getClass()+" to map (key was: "+k+")");
				}
				else if (vb instanceof Collection) {
					throw new IllegalArgumentException("can't merge instance of "+va.getClass()+" to collection (key was: "+k+")");
				}
				
				a.put(k, vb);
			}
		}
		
		return a;
	}

}
