package de.brightbyte.util;

import java.lang.reflect.Array;
import java.util.Iterator;

public class ArrayIterator<E> implements Iterator<E> {

	private Object array;
	private int index;
	
	public ArrayIterator(Object array) {
		super();
		Class clazz = array.getClass();
		if (clazz.isArray()) {
			this.array = array;
			this.index = 0;
		}
		else throw new IllegalArgumentException("object must be an array");
	}

	public boolean hasNext() {
		return index < Array.getLength(array);
	}

	public E next() {
		return (E)Array.get(array, index++);
	}

	public void remove() {
		throw new UnsupportedOperationException();		
	}
	
}
