package de.brightbyte.text;

import junit.framework.TestCase;

public class DurationFormatTest extends TestCase {

	public void testFormat() {
		DurationFormat format = new DurationFormat();
		
		assertEquals("0.25s", format.format(250));
		assertEquals("0.25s", format.format(0.25));
		
		assertEquals("59.221s", format.format(59221));
		assertEquals("59.221s", format.format(59.221));
		
		assertEquals("5m 17.023s", format.format(5*60*1000 + 17*1000 + 23));
		assertEquals("5m 17.023s", format.format(5*60 + 17 + 0.023));
		
		assertEquals("8h 5m 17.023s", format.format(8*60*60*1000 + 5*60*1000 + 17*1000 + 23));
		assertEquals("8h 5m 17.023s", format.format(8*60*60 + 5*60 + 17 + 0.023));
		
		assertEquals("3d 8h 5m 17.023s", format.format(3*24*60*60*1000 + 8*60*60*1000 + 5*60*1000 + 17*1000 + 23));
		assertEquals("3d 8h 5m 17.023s", format.format(3*24*60*60 + 8*60*60 + 5*60 + 17 + 0.023));
	}

}
