package de.brightbyte.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class DurationFormat extends Format {
	
	public static final DurationFormat instance = new DurationFormat(); 
	
	protected static final long SEC = 1000;
	protected static final long MIN = 60 * SEC;
	protected static final long HOUR = 60 * MIN;
	protected static final long DAY = 24 * HOUR;
	
	//TODO: support patterns, FieldPosition, etc

	public StringBuffer format(long millisec, StringBuffer toAppendTo, FieldPosition pos) {
		long days = millisec / DAY;
		millisec -= days * DAY;
		
		long hours = millisec / HOUR;
		millisec -= hours * HOUR;
		
		long minutes = millisec / MIN;
		millisec -= minutes * MIN;
		
		long seconds = millisec / SEC;
		millisec -= seconds * SEC;
		
		if (days>0) {
			toAppendTo.append(days);
			toAppendTo.append('d');
		}
		
		if (days>0 || hours>0) {
			if (days>0) toAppendTo.append(' ');
			toAppendTo.append(hours);
			toAppendTo.append('h');
		}
		
		if (days>0 || hours>0 || minutes>0) {
			if (days>0 || hours>0) toAppendTo.append(' ');
			toAppendTo.append(minutes);
			toAppendTo.append('m');
		}
		
		//HACK
		double sec = seconds + (millisec / 1000.0);
		
		if (days>0 || hours>0 || minutes>0) toAppendTo.append(' ');
		toAppendTo.append(sec);
		toAppendTo.append('s');
		
		return toAppendTo;
	}

	@Override
	public StringBuffer format(Object obj, StringBuffer toAppendTo,
			FieldPosition pos) {
		
		if (obj instanceof String) {
			obj = parseObject((String)obj, new ParsePosition(0));
		}
		
		Number n = (Number)obj;
		long ms;
		if (n instanceof Double || n instanceof Float) {
			ms = Math.round(n.doubleValue()*1000.0); 
		}
		else {
			ms = n.longValue();
		}
		
		return format(ms, toAppendTo, pos);
	}

	@Override
	public Long parseObject(String source, ParsePosition pos) {
		throw new UnsupportedOperationException(); //TODO: implement
	}

}
