package de.brightbyte.spa;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeoutException;

import de.brightbyte.abstraction.Disposer;
import de.brightbyte.abstraction.Instantiator;

public class ThreadAwarePool<T> extends SimplePool<T> {

	protected static class Entry<T> extends SimplePool.Entry<T> {
		public Thread owner;
		
		public Entry(T object) {
			super(object);
		}

		public void leased() {
			owner = Thread.currentThread();
			super.leased();
		}
		
		public void released() {
			super.leased();
			owner = null;
		}
	}
	
	protected Map<Thread, Entry<T>> owners = new HashMap<Thread, Entry<T>>(); //TODO
	
	public ThreadAwarePool(Instantiator<T> instantiator, Disposer<T> disposer) {
		super(instantiator, disposer);
	}

	public T lease(int timeout) throws InterruptedException, InstantiationException, TimeoutException {
		synchronized (lock) {
			Thread th = Thread.currentThread();
			
			Entry<T> e = owners.get(th);
			if (e!=null) return e.object;
			
			e = (Entry<T>)super.leaseEntry(timeout);
			owners.put(th, e);
			return e.object;
		}
	}
	
	protected Entry<T> makeEntry(T rc) {
		return new Entry<T>(rc);
	}
	
	public void release(T obj) {
		synchronized (lock) {
			Thread th = Thread.currentThread();
			Entry<T> e = owners.get(th);
			
			if (e==null || e.object!=obj) throw new IllegalArgumentException("not owned by current thread: "+obj);
			
			super.releaseEntry(obj);
			owners.remove(th);
		}
	}
	
	public void janitize() throws InstantiationException {
		synchronized (lock) {
			//release resources owned by dead threads
			Iterator<Map.Entry<Thread,Entry<T>>> it = owners.entrySet().iterator();
			while (it.hasNext()) {
				Map.Entry<Thread,Entry<T>> e = it.next();
				Thread th = e.getKey();
				
				if (!th.isAlive()) {
					it.remove();
					release(e.getValue().object);
				}
			}
		}

		super.janitize();
	}

}
