package de.brightbyte.spa;

import java.util.concurrent.TimeoutException;

public class SingletonPool<T> implements Pool<T> {
	
	protected T singleton;
	
	public SingletonPool(T singleton) {
		this.singleton = singleton;
	}

	public void janitize() throws InstantiationException {
		//noop
	}

	public T lease(int timeout) throws InterruptedException,
			InstantiationException, TimeoutException {
		return singleton;
	}

	public void release(T obj) {
		//noop
	}

	public void remove(T obj) {
		throw new UnsupportedOperationException();
	}

}
