/**
 * 
 */
package de.brightbyte.job;

import de.brightbyte.job.Progress.Event;
import de.brightbyte.job.Progress.Listener;

public class ProgressRateTracker implements Listener {

	protected long lastTime = -1;
	protected long lastPeriod = -1;
	protected long lastStep = -1;

	protected long startTime = -1;
	protected long total = -1;
	protected long position = -1;
	protected int status = Progress.NONE;

	public void reset() {
		lastTime = -1;
		lastPeriod = -1;
		lastStep = -1;

		startTime = -1;
		total = -1;
		position = -1;
		status = Progress.NONE;
	}

	public void progress(Event event) {
		status = event.getType();
		if (event.getTotal()>-1) total = event.getTotal();
		
		long now = System.currentTimeMillis();
		boolean ignore = false;

		switch (status) {
			case Progress.NONE:
			case Progress.START:
				startTime = now;
				lastTime = now;
				lastStep = -1;
				lastPeriod = 0;
				
			break;
			
			case Progress.PROGRESS:
			case Progress.DONE:
			case Progress.FAILED:
				if (startTime < 0) startTime = now;
				
				long step = position < 0 ? event.getPosition() : (event.getPosition() - position);
				 
				if (step>0) {
					lastStep = step;
					lastPeriod = lastTime < 0 ? (now - startTime) : (now - lastTime);
					if (lastPeriod<1) lastPeriod = 1;
				}
				else ignore = true;
			break;
		}		
		
		if (!ignore) {
			lastTime = now;
			position = event.getPosition();
		}
	}
	
	public long getTotal() {
		return total;
	}

	public long getPosition() {
		return position;
	}

	public long getLastPeriod() {
		return lastPeriod;
	}

	public long getLastStep() {
		return lastStep;
	}

	public long getLastTime() {
		return lastTime;
	}

	public long getStartTime() {
		return startTime;
	}

	public int getStatus() {
		return status;
	}

	public long getTimeElapsed() {
		return startTime < 0 ? -1 : System.currentTimeMillis() - startTime;
	}

	public double getCurrentRate() {
		if (lastStep > 0 && lastPeriod > 0) return (double)lastStep * 1000/lastPeriod;
		else return -1;
	}

	public double getAverageRate() {
		if (position > 0 && startTime > 0) return (double)position * 1000/getTimeElapsed();
		else return -1;
	}

	public double getCombinedRate() {
		if (position > 0 && total > 0 && lastStep > 0 && lastPeriod > 0) {
			double c = getCompletion();
			double rr = getCurrentRate();
			double ar = getAverageRate();
			double rate = c * rr + (1-c) * ar; 
			return rate;
		}
		else return -1;
	}

	public double getCompletion() {
		if (position >= 0 && total > 0) return (double)position/total;
		else return -1;
	}
	
	public long getCombinedETA() {
		if (position > 0 && total > 0) {
			long rem = total - position;
			double rate = (lastStep > 0 && lastPeriod > 0) ? getCombinedRate() : getAverageRate();
			return (long)(rem/rate);
		}
		else return -1;
	}
	
	public String toString() {
		//return ""+getCombinedETA();
		long eta = getCombinedETA();

		long d = eta / (24*60*60);
		eta -= d * (24*60*60);
		
		long h = eta / (60*60);
		eta -= h * (60*60);

		long m = eta / 60;
		eta -= m * 60;
		
		if (d>0) return d+"d "+h+"h"; 
		if (h>0) return h+"h "+m+"m"; 
		return m+"m "+eta+"s";
	}

}