package de.brightbyte.job;

import java.util.HashMap;
import java.util.Map;

import de.brightbyte.job.Progress.Event;
import de.brightbyte.job.Progress.Source;

public class MultiProgress extends Progress.State implements Progress.Listener {
	
	public MultiProgress(Source source, String item) {
		super(source, item);
	}

	protected static class ItemState {

		public String item;
		public int status;
		public long total;
		public long position;

		public ItemState(String item) {
			this(item, -1);
		}
		public ItemState(String item, long total) {
			this.item = item;
			this.status = Progress.NONE;
			this.total = total;
			this.position = -1;
		}
		
		public void update(Progress.Event ev) {
			status = ev.getType();
			if (ev.getTotal()>=0) total = ev.getTotal();
			if (ev.getPosition()>=0) position = ev.getPosition();
		}
	}
	
	protected Map<String, ItemState> items = new HashMap<String, ItemState>();
	protected boolean started = false;
	protected boolean closed = false;
	
	public void reset() {
		items.clear();
		if (started) fireDone(-1);
		started = false;
	}
	
	public void addItem(String item, long total) {
		items.put(item, new ItemState(item, total));
		if (started) update();
	}

	public void removeItem(String item) {
		if (items.remove(item)!=null) {
			if (started) update();
			if (items.isEmpty()) {
				fireDone(-1);
				started = false;
			}
		}
	}

	protected void update() {
		long pos = 0;
		long tot = 0;
		
		ItemState[] states = items.values().toArray(new ItemState[items.size()]);
		
		for (int i = 0; i < states.length; i++) {
			ItemState st = states[i];
			switch (st.status) {
				case Progress.NONE:
				case Progress.START:
					if (st.total>0) tot += st.total;
				break;
				case Progress.PROGRESS:
					if (st.total>0) tot += st.total;
					if (st.position>0) pos += st.position;
				break;
				case Progress.DONE:
					if (st.total>0) tot += st.total;
					if (st.position>0) pos += st.total;
				break;
				case Progress.FAILED:
					if (st.total>0) tot += st.position;
					if (st.position>0) pos += st.position;
				break;
			}
		}
		
		if (!started) {
			fireStart(tot);
			started = true;
		}
		
		if (closed && getCompletedItemCount() == getItemCount()) {
			fireDone(tot);
		}
		else {
			fireProgress(pos, tot);
		}
	}

	public void progress(Event event) {
		int type = event.getType();
		String item = event.getItem();
		ItemState st = items.get(item);
		
		if (st==null && type == Progress.START) {
			addItem(item, event.getTotal());
			st = items.get(item);
		}
		
		if (st!=null) {			
			st.update(event);
			update();
		}
	}

	public int getItemCount() {
		return items.size();
	}

	public int getCompletedItemCount() {
		//FIXME: calculate the count in update(), just return it here!
		
		int c = 0;
		ItemState[] states = items.values().toArray(new ItemState[items.size()]);
		
		for (int i = 0; i < states.length; i++) {
			ItemState st = states[i];
			if (st.status == Progress.DONE || st.status == Progress.FAILED) c++;
		}
		
		return c;
	}
	
	public void close() {
		if (closed) return;
		closed = true;
		if (isRunning() && getCompletedItemCount() == getItemCount()) {
			fireDone(-1);
		}
	}

}
