package de.brightbyte.job;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class FinishedFuture<T> implements Future<T> {
	
	protected T value;
	protected Throwable error;
	
	public FinishedFuture(T value) {
		this(value, null);
	}	

	public FinishedFuture(T value, Throwable error) {
		super();
		this.value = value;
		this.error = error;
	}

	public boolean cancel(boolean mayInterruptIfRunning) {
		return false;
	}

	public T get() throws ExecutionException {
		if (error!=null) throw new ExecutionException(error);
		return value;
	}

	public T get(long timeout, TimeUnit unit) throws ExecutionException {
		return get();
	}

	public boolean isCancelled() {
		return false;
	}

	public boolean isDone() {
		return true;
	}

}
