package de.brightbyte.job;

import java.lang.reflect.InvocationTargetException;

import javax.swing.SwingUtilities;

public class AsyncUtil {
	public static void runInEventDispatchThread(Runnable runnable) {
		if (SwingUtilities.isEventDispatchThread()) 
			runnable.run();
		else {
			SwingUtilities.invokeLater(runnable);
		}
	}
	
	public static void runInEventDispatchThreadAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
		if (SwingUtilities.isEventDispatchThread()) 
			runnable.run();
		else {
			SwingUtilities.invokeAndWait(runnable);
		}
	}

	/**
	 * Invokes the given runnable in the AWT invent dispatcher thread and waits until it has finished. 
	 * If this method is invoked from the current AWT event dispatcher thread, it calls r.run()
	 * synchronously. Otherwise, it calls SwingUtilities.invokeAndWait( r )
	 */
	public static void awtInvoke(Runnable r) throws InterruptedException {
		if (SwingUtilities.isEventDispatchThread()) {
				r.run();
		}
		else {
			try {
				SwingUtilities.invokeAndWait( r );
			} catch (InvocationTargetException e) {
				Throwable exx = e.getCause();
				if (exx instanceof Error) throw (Error)exx;
				else if (exx instanceof RuntimeException) throw (RuntimeException)exx;
				else throw new Error("unexpected exception", e);
			}
		}
	}

	/**
	 * Invokes the given runnable in the AWT invent dispatcher thread. If this method is invoked
	 * from the current AWT event dispatcher thread, it calls r.run() synchronously. Otherwise,
	 * it calls SwingUtilities.invokeLater( r )
	 */
	public static void awtSchedule(Runnable r) {
		runInEventDispatchThread(r);
	}
}
