package de.brightbyte.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class WriterOutput implements Output {
	protected Writer out;
	protected String newline;
	private boolean autoflush = true;
	
	public WriterOutput(OutputStream out, String enc) throws UnsupportedEncodingException {
		this(enc == null ? new OutputStreamWriter(out) : new OutputStreamWriter(out, enc), null);
	}
	
	public WriterOutput(Writer out) {
		this(out, null);
	}
	
	public WriterOutput(Writer out, String newline) {
		if (newline==null) newline = System.getProperty("line.separator");
		
		this.out = out;
		this.newline = newline;
	}

	public void println(Object obj) {
		try {
			writeln(String.valueOf(obj));
		} catch (IOException e) {
			//TODO: remember?
		}
	}

	public void write(String s) throws IOException {
		out.write(s);
	}

	public void writeln(String s) throws IOException {
		write(s);
		newline();
	}

	public boolean isAutoflush() {
		return autoflush;
	}

	public void setAutoflush(boolean autoflush) {
		this.autoflush = autoflush;
	}

	public void close() throws IOException {
		out.close(); //TODO: optionalyl keep alive! 
	}

	public void newline() throws IOException {
		write(newline);
		if (autoflush) out.flush();
	}

	public void flush() throws IOException {
		out.flush();
	}
}
