package de.brightbyte.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public class Prompt {
	
	protected BufferedReader in;
	protected PrintWriter out;
	private IOException error;

	public Prompt() {
		this( ConsoleIO.newReader() , ConsoleIO.writer );
	}
	
	public Prompt(InputStream in, OutputStream out, String enc) throws UnsupportedEncodingException {
		this( enc == null ? new InputStreamReader(in) : new InputStreamReader(in, enc),
				enc == null ? new OutputStreamWriter(out) : new OutputStreamWriter(out, enc) );
	}
	
	public Prompt(Reader in, Writer out) {
		this( in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in),
				out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out, true) );
	}
	
	public Prompt(BufferedReader in, PrintWriter out) {
		super();
		this.in = in;
		this.out = out;
	}

	public void print(String s) {
		out.print(s);
		out.flush();
	}
	
	public void println(String s) {
		out.println(s);
		out.flush();
	}
	
	public String getln() {
		if (error!=null) return null;
		try {
			return in.readLine();
		} catch (IOException e) {
			error = e;
			return null;
		}
	}
	
	public IOException getError() {
		return error;
	}
	
	public String prompt(String msg, String def) {
		print(msg+"> ");
		String s = getln();
		if (s==null) return null; //EOF
		if (s.length()==0) return def;
		return s.trim();
	}

	public String prompt(String msg, List<String> options, String def) {
		StringBuilder m = new StringBuilder(msg);
		
		if (options!=null) {
			m.append(" [");
			boolean first = true;
			for (String op: options) {
				if (first) first = false;
				else m.append('/');
				m.append(op);
			}
			m.append(']');
		}
		
		msg = m.toString();
		
		while (true) {
			String s = prompt(msg, def);
			if (s==null) return null; //EOF, or def=null
			
			if (options==null || options.contains(s)) {
				return s;
			}
		}
	}

	public String prompt(String msg, String[] opt, String def) {
		return prompt(msg, Arrays.asList(opt), def);
	}

	public BufferedReader getIn() {
		return in;
	}

	public PrintWriter getOut() {
		return out;
	}

	
}
