package de.brightbyte.io;

import java.io.IOException;
import java.io.PrintStream;

public class PrintStreamOutput implements Output {
	protected PrintStream out;
	
	public PrintStreamOutput(PrintStream out) {
		this.out = out;
	}

	public void println(Object obj) {
		out.println(obj);
	}

	public void write(String s) throws IOException {
		out.print(s);
		if (out.checkError()) throw new IOException("print() failed");
	}

	public void writeln(String s) throws IOException {
		out.println(s);
		if (out.checkError()) throw new IOException("println() failed");
	}

	public void close() throws IOException {
		out.close(); //TODO: optionalyl keep alive! 
	}

	public void newline() throws IOException {
		out.println();
	}

	public void flush() throws IOException {
		out.flush();
	}

}
