package de.brightbyte.io;

import java.io.IOException;

public interface Output {
	public void write(String s) throws IOException;
	public void writeln(String s) throws IOException;
	public void println(Object obj);
	public void close() throws IOException;
	public void newline() throws IOException;
	public void flush() throws IOException;

	public static final Output NULL = new Output() {
		
		public void writeln(String s) throws IOException {
			//noop
		}
	
		public void write(String s) throws IOException {
			//noop
		}
	
		public void println(Object obj) {
			//noop
		}
	
		public void newline() throws IOException {
			//noop
		}
	
		public void flush() throws IOException {
			//noop
		}
	
		public void close() throws IOException {
			//noop
		}
	
	};	
}
