package de.brightbyte.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import de.brightbyte.job.Progress;
import de.brightbyte.job.Progress.Listener;

public class MonitoredOutputStream extends FilterOutputStream implements Progress.Source {

	protected Progress.State progress;

	public MonitoredOutputStream(OutputStream out, String item, long length) {
		super(out);
		
		progress = new Progress.State(this, item);
		progress.setTotal(length, false);
	}

	public MonitoredOutputStream(OutputStream out, Progress.State progress) {
		super(out);
		
		this.progress = progress;
		this.progress.reset();
	}

	public void addProgressListener(Listener li) {
		progress.addProgressListener(li);
	}

	public void removeProgressListener(Listener li) {
		progress.removeProgressListener(li);
	}

	@Override
	public void close() throws IOException {
		try {
			super.close();
			progress.fireDone(-1);
		}
		catch (IOException ex) {
			progress.fireFailed(ex);
			throw ex;			
		}
	}

	@Override
	public void flush() throws IOException {
		try {
			super.flush();
		}
		catch (IOException ex) {
			progress.fireFailed(ex);
			throw ex;			
		}
	}

	@Override
	public void write(byte[] b) throws IOException {
		write(b, 0, b.length);
	}

	@Override
	public void write(byte[] b, int off, int len) throws IOException {
		if (len > b.length - off) len = b.length - off;
		if (len<=0) return;

		try {
			super.write(b, off, len);

			progress.fireStep(len);

			if (progress.getTotal()<=progress.getPosition()) progress.fireDone(-1);
		}
		catch (IOException ex) {
			progress.fireFailed(ex);
			throw ex;			
		}
	}

	@Override
	public void write(int b) throws IOException {
		try {
			super.write(b);

			progress.fireStep(1);

			if (progress.getTotal()<=progress.getPosition()) progress.fireDone(-1);
		}
		catch (IOException ex) {
			progress.fireFailed(ex);
			throw ex;			
		}
	}

	
}
