package de.brightbyte.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

import de.brightbyte.job.Progress;
import de.brightbyte.job.Progress.Listener;

public class MonitoredInputStream extends FilterInputStream implements Progress.Source {
	
	protected Progress.State progress;

	protected MonitoredInputStream(InputStream in, String item, long length) {
		super(in);
		
		progress = new Progress.State(this, item);
		progress.setTotal(length, false);
	}

	public MonitoredInputStream(InputStream in, Progress.State progress) {
		super(in);
		
		this.progress = progress;
		this.progress.reset();
	}

	@Override
	public boolean markSupported() {
		return false;
	}

	@Override
	public int read() throws IOException {
		try {
			int ch = super.read();
			
			if (ch<0) progress.fireDone(-1);
			else progress.fireStep(1);
			
			return ch;
		} catch (IOException ex) {
			progress.fireFailed(ex);
			throw ex;
		}
	}

	@Override
	public void close() throws IOException {
		try {
			super.close();
			progress.fireDone(-1);
		}
		catch (IOException ex) {
			progress.fireFailed(ex);
			throw ex;			
		}
	}

	@Override
	public int read(byte[] b) throws IOException {
		return read(b, 0, b.length);
	}
	
	@Override
	public int read(byte[] b, int off, int len) throws IOException {
		try {
			int c = super.read(b, off, len);

			if (c<0) progress.fireDone(-1);
			else progress.fireStep(c);

			return c;
		}
		catch (IOException ex) {
			progress.fireFailed(ex);
			throw ex;			
		}
	}

	@Override
	public long skip(long n) throws IOException {
		try {
			long c = super.skip(n);
			
			progress.fireStep(c);
			if (c < n) progress.fireDone(-1);

			return c;
		}
		catch (IOException ex) {
			progress.fireFailed(ex);
			throw ex;			
		}
	}

	public void addProgressListener(Listener li) {
		progress.addProgressListener(li);
	}

	public void removeProgressListener(Listener li) {
		progress.removeProgressListener(li);
	}

	
}
