package de.brightbyte.io;

import static de.brightbyte.util.LogLevels.LOG_ERROR;
import static de.brightbyte.util.LogLevels.LOG_FINE;
import static de.brightbyte.util.LogLevels.LOG_FINER;
import static de.brightbyte.util.LogLevels.LOG_INFO;
import static de.brightbyte.util.LogLevels.LOG_WARNING;

import java.io.IOException;

public class LogOutput implements LeveledOutput {
	
	public static final LogOutput console = new LogOutput();
	
	protected Output out;
	protected int logLevel = LOG_INFO;

	public LogOutput() {
		this(ConsoleIO.output);
	}
	
	public LogOutput(Output out) {
		this.out = out;
	}
	
	public void debug(String msg) {
		if (out == null || logLevel>LOG_FINE) return;
		out.println("DEBUG: "+msg);
	}

	public void info(String msg) {
		if (out == null || logLevel>LOG_INFO) return;
		out.println("LOG: "+msg);
	}

	public void trace(String msg) {
		if (out == null || logLevel>LOG_FINER) return;
		out.println("TRACE: "+msg);
	}

	public void warn(String msg) {
		warn(msg, null);
	}
	
	public void warn(String msg, Throwable ex) {
		if (out == null || logLevel>LOG_WARNING) return;
		out.println("WARNING: "+msg);
		if (ex!=null) ex.printStackTrace(System.err);
	}

	public void error(String msg, Throwable ex) {
		if (out == null || logLevel>LOG_ERROR) return;
		out.println("ERROR: "+msg);
		if (ex!=null) ex.printStackTrace(System.err);
	}

	public void setLogLevel(int ll) {
		logLevel = ll;
	}

	public void close() throws IOException {
		out.close();
	}

	public void flush() throws IOException {
		out.flush();
	}

	public void newline() throws IOException {
		out.newline();
	}

	public void println(Object obj) {
		out.println(obj);
	}

	public void write(String s) throws IOException {
		out.write(s);
	}

	public void writeln(String s) throws IOException {
		out.writeln(s);
	}

	
}
