package de.brightbyte.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import de.brightbyte.data.cursor.CursorIterator;
import de.brightbyte.data.cursor.DataCursor;
import de.brightbyte.data.cursor.DataSet;
import de.brightbyte.util.PersistenceException;
import de.brightbyte.util.UncheckedPersistenceException;

public class LineDataSet implements DataSet<String> {

	protected URL url;
	protected String enc;
	
	protected Reader open() throws PersistenceException {
		try {
			URLConnection conn = url.openConnection();
			String e = enc != null ? enc : conn.getContentEncoding();
			
			InputStream in = conn.getInputStream();
			return e == null ? new InputStreamReader(in) : new InputStreamReader(in, e);
		} catch (IOException e) {
			throw new PersistenceException(e);
		}
	}

	public DataCursor<String> cursor() throws PersistenceException {
		return new LineCursor(open());
	}

	public Iterator<String> iterator() {
		try {
			return new CursorIterator<String>(cursor());
		} catch (PersistenceException e) {
			throw new UncheckedPersistenceException(e);
		}
	}

	
	public List<String> load() {
		ArrayList<String> r = new ArrayList<String>();
		for (String x: this) r.add(x);
		return r;
	}
	
}
