package de.brightbyte.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

import de.brightbyte.data.cursor.DataCursor;
import de.brightbyte.util.PersistenceException;

public class LineCursor implements DataCursor<String> {
	
	protected BufferedReader reader;

	public LineCursor(InputStream in, String enc) throws UnsupportedEncodingException {
		this( enc==null ? new InputStreamReader(in) : new InputStreamReader(in, enc) );
	}

	public LineCursor(Reader rd) {
		this(rd instanceof BufferedReader ? (BufferedReader)rd : new BufferedReader(rd));
	}
	
	public LineCursor(BufferedReader reader) {
		if (reader==null) throw new NullPointerException();
		this.reader = reader;
	}

	public void close() {
		try {
			reader.close();
		} catch (IOException e) {
			//ignore. who cares?
		}
	}

	public String next() throws PersistenceException {
		try {
			return reader.readLine();
		} catch (IOException e) {
			throw new PersistenceException(e);
		}
	}

	protected void finalize() {
		close();
	}
}
