package de.brightbyte.io;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaLoggerOutput implements LeveledOutput {
	protected Logger out;
	protected Level level;
	protected StringBuffer buffer = new StringBuffer();
	
	public JavaLoggerOutput(Logger out, Level level) {
		if (out==null) throw new NullPointerException();
		if (level==null) throw new NullPointerException();
		
		this.out = out;
		this.level = level;
	}

	public void println(Object obj) {
		writeln(String.valueOf(obj));
	}

	public void write(String s) {
		buffer.append(s);
	}

	public void writeln(String s) {
		flush();
		log(s);
	}

	protected void log(String s) {
		out.log(level, s);
	}

	protected void log(Level level, String s, Throwable ex) {
		out.logp(level, null, null, s, ex);
	}

	public void close() throws IOException {
		out = null;
	}

	public void newline() {
		flush();
	}

	public void flush()  {
		if (buffer.length()>0) {
			log(buffer.toString());
			buffer.setLength(0);
		}
	}
	
	public void debug(String msg) {
		flush();
		log(Level.FINE, msg, null);
	}

	public void trace(String msg) {
		flush();
		log(Level.FINER, msg, null);
	}

	public void info(String msg) {
		flush();
		log(Level.INFO, msg, null);
	}

	public void warn(String msg) {
		flush();
		log(Level.WARNING, msg, null);
	}

	public void warn(String msg, Throwable ex) {
		flush();
		log(Level.WARNING, msg, ex);
	}

	public void error(String msg, Throwable ex) {
		flush();
		log(Level.SEVERE, msg, ex);
	}
	
}
