package de.brightbyte.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;


public class IOUtil {
	
	public static int pump(InputStream in, OutputStream out) throws IOException {
		byte buffer[] = new byte[1024*16];
		
		int c;
		int count = 0;
				
		while ((c = in.read(buffer)) != -1) {
			out.write(buffer, 0, c);
			count += c;
		}
		
		return count;
	}

	public static int pump(Reader in, Writer out) throws IOException {
		char buffer[] = new char[1024*8];
		
		int c;
		int count = 0;
				
		while ((c = in.read(buffer)) != -1) {
			out.write(buffer, 0, c);
			count += c;
		}
		
		return count;
	}

	public static void download(URL u, File f) throws IOException {
		InputStream in= u.openStream();
		OutputStream out= new BufferedOutputStream(new FileOutputStream(f));
		
		pump(in, out);
		
		out.close();
		in.close();
	}

	public static String slurp(URL u) throws IOException {
		URLConnection conn= u.openConnection();
		InputStream in= conn.getInputStream();
		
		String s= slurp(in, conn.getContentEncoding());
		in.close();
		
		return s;
	}
	
	public static String slurp(URL u, String enc) throws IOException {
		InputStream in= u.openStream();
		
		String s= slurp(in, enc);
		in.close();
		
		return s;
	}
	
	public static String slurp(File f, String enc) throws IOException {
		FileInputStream in= new FileInputStream( f );
		String s= slurp(in, enc);
		in.close();
		
		return s;
	}
	
	public static String slurp(InputStream in, String enc) throws IOException {
		InputStreamReader rd= enc == null ? new InputStreamReader(in) : new InputStreamReader(in, enc);
		String s= slurp(rd);
		rd.close();
		
		return s;
	}
	
	public static String slurp(Reader rd) throws IOException {
		StringWriter s= new StringWriter();
		
		pump(rd, s);
		
		return s.toString();
	}

	public static void spit(File f, String data, String encoding, boolean append) throws IOException {
		OutputStream out = new FileOutputStream(f, append);
		Writer wr = new OutputStreamWriter(out, encoding);
		
		wr.write(data);
		
		wr.close();
		out.close();
	}	
	
	public static void move(File f, File tgt) {
		throw new UnsupportedOperationException("oops"); //FIXME
	}
}
