package de.brightbyte.io;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

import de.brightbyte.util.SystemUtils;

public class ConsoleIO {
	
	private static class SystemWriter extends PrintWriter {
		PrintWriter pwr = null;

		protected SystemWriter() {
			super(new OutputStreamWriter(System.out));
		}

		@Override
		public PrintWriter append(char c) {
			return pwr.append(c);
		}

		@Override
		public PrintWriter append(CharSequence csq, int start, int end) {
			return pwr.append(csq, start, end);
		}

		@Override
		public PrintWriter append(CharSequence csq) {
			return pwr.append(csq);
		}

		@Override
		public boolean checkError() {
			return pwr.checkError();
		}

		@Override
		public void close() {
			pwr.flush(); //NOTE: don't close!
		}

		@Override
		public void flush() {
			pwr.flush();
		}

		@Override
		public PrintWriter format(Locale l, String format, Object... args) {
			return pwr.format(l, format, args);
		}

		@Override
		public PrintWriter format(String format, Object... args) {
			return pwr.format(format, args);
		}

		@Override
		public void print(boolean b) {
			pwr.print(b);
		}

		@Override
		public void print(char c) {
			pwr.print(c);
		}

		@Override
		public void print(char[] s) {
			pwr.print(s);
		}

		@Override
		public void print(double d) {
			pwr.print(d);
		}

		@Override
		public void print(float f) {
			pwr.print(f);
		}

		@Override
		public void print(int i) {
			pwr.print(i);
		}

		@Override
		public void print(long l) {
			pwr.print(l);
		}

		@Override
		public void print(Object obj) {
			pwr.print(obj);
		}

		@Override
		public void print(String s) {
			pwr.print(s);
		}

		@Override
		public PrintWriter printf(Locale l, String format, Object... args) {
			return pwr.printf(l, format, args);
		}

		@Override
		public PrintWriter printf(String format, Object... args) {
			return pwr.printf(format, args);
		}

		@Override
		public void println() {
			pwr.println();
		}

		@Override
		public void println(boolean x) {
			pwr.println(x);
		}

		@Override
		public void println(char x) {
			pwr.println(x);
		}

		@Override
		public void println(char[] x) {
			pwr.println(x);
		}

		@Override
		public void println(double x) {
			pwr.println(x);
		}

		@Override
		public void println(float x) {
			pwr.println(x);
		}

		@Override
		public void println(int x) {
			pwr.println(x);
		}

		@Override
		public void println(long x) {
			pwr.println(x);
		}

		@Override
		public void println(Object x) {
			pwr.println(x);
		}

		@Override
		public void println(String x) {
			pwr.println(x);
		}

		@Override
		protected void setError() {
			//noop
		}

		@Override
		public void write(char[] buf, int off, int len) {
			pwr.write(buf, off, len);
		}

		@Override
		public void write(char[] buf) {
			pwr.write(buf);
		}

		@Override
		public void write(int c) {
			pwr.write(c);
		}

		@Override
		public void write(String s, int off, int len) {
			pwr.write(s, off, len);
		}

		@Override
		public void write(String s) {
			pwr.write(s);
		}
	}
	
	
	private static String encoding;
	public static final SystemWriter writer = new SystemWriter();
	public static final Output output = new WriterOutput(writer);
		
	static {
		try {
			String enc = SystemUtils.getPropertySafely("file.encoding", "UTF-8");
			setEncoding(enc);
		} catch (UnsupportedEncodingException e) {
			throw new Error("failed to create writer for stdout using encoding "+encoding);
		}
	}

	public static String getEncoding() {
		return encoding;
	}

	public static void setEncoding(String enc) throws UnsupportedEncodingException {
		if (enc.equals(encoding)) return;
		
		writer.pwr = new PrintWriter( new OutputStreamWriter(System.out, enc));
		encoding = enc;
	}

	public static Reader newReader() {
		try {
			return new InputStreamReader(System.in, encoding);
		} catch (UnsupportedEncodingException e) {
			throw new Error("failed to create system reader using encoding "+encoding);
		}
	}

	public static void main(String[] args) throws UnsupportedEncodingException {
		ConsoleIO.output.println("äöü");
		setEncoding("ISO-8859-1");
		ConsoleIO.output.println("äöü");
		setEncoding("UTF-8");
		ConsoleIO.output.println("äöü");
	}
}
